% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsr.mcSimulation.R
\name{plsr.mcSimulation}
\alias{plsr.mcSimulation}
\title{Partial Least Squares Regression (PLSR) of Monte Carlo simulation results.}
\usage{
plsr.mcSimulation(object, resultName = NULL, variables.x = names(object$x),
  method = "oscorespls", scale = TRUE, ncomp = 2, ...)
}
\arguments{
\item{object}{An object of class \code{mcSimulation}.}

\item{resultName}{\code{character}: indicating the name of the component of
the simulation function (\code{model_function}) whose results histogram
shall be generated. If \code{model_function} is single valued, no name
needs to be supplied. Otherwise, one valid name has to be specified.
Defaults to \code{NULL}.}

\item{variables.x}{\code{character} or \code{character} vector: Names of the 
components of the input variables to the simulation function, i.e. the
names of the variables in the input \code{estimate} which random sampling
results shall be displayed. Defaults to all components.}

\item{method}{the multivariate regression method to be used.  If
    \code{"model.frame"}, the model frame is returned.}

\item{scale}{numeric vector, or logical.  If numeric vector, \eqn{X}
    is scaled by dividing each variable with the corresponding element
    of \code{scale}.  If \code{scale} is \code{TRUE}, \eqn{X} is scaled
    by dividing each variable by its sample standard deviation.  If
    cross-validation is selected, scaling by the standard deviation is
    done for every segment.}

\item{ncomp}{the number of components to include in the model (see below).}

\item{...}{further arguments to be passed to \code{\link[pls:plsr]{plsr}}.}
}
\value{
An object of class \code{\link[pls:mvr]{mvr}}.
}
\description{
Perform a Partial Least Squares Regression (PLSR) of Monte Carlo simulation results.
}
\seealso{
\code{\link{mcSimulation}}, \code{\link[pls:plsr]{plsr}}, 
\code{\link[pls:summary.mvr]{summary.mvr}}, \code{\link[pls:biplot.mvr]{biplot.mvr}}, 
\code{\link[pls:coef.mvr]{coef.mvr}}, \code{\link[pls:plot.mvr]{plot.mvr}},
}
