% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_keyvalue.R
\docType{data}
\name{key_value_data}
\alias{key_value_data}
\title{Key-value datasets for code translation}
\description{
Dictionary files to translate key codes to value in plain text (or reverse).
}
\details{
Each file has two columns, "key" and "value". The key is a unique (mostly) numeric code
and the key is a character string description.
The data sets can be divided into four categories:
\itemize{
 \item Geographic codes: \link{region}, \link{lan}, \link{kommun} and \link{forsamling}
 \item Administrative codes: \link{sjukhus}, \link{klinik} and \link{patologiavdelning}
 \item Diagnose codes: \link{t_rtr}, \link{n_rtr}, \link{m_rtr}, \link{figo},
 \link{tnmgrund}, \link{sida}, \link{icd7}, \link{icd9}, \link{icd10}, \link{icdo}, \link{icdo3},
  \link{snomed}, \link{snomed3} and \link{pad}
 \item Other codes: \link{kon}
}
The intention of these data files is to be used by the \link{decode} and \link{code} functions.
}
\seealso{
\link{decode}, \link{keyvalue}

Other key_value_data: \code{\link{distrikt}},
  \code{\link{figo}}, \code{\link{forsamling}},
  \code{\link{hemort}}, \code{\link{hsn}},
  \code{\link{icd10}}, \code{\link{icd7_grov}},
  \code{\link{icd7}}, \code{\link{icd9}},
  \code{\link{icdo3_grov}}, \code{\link{icdo3}},
  \code{\link{icdo}}, \code{\link{klinik}},
  \code{\link{kommun}}, \code{\link{kon}},
  \code{\link{lan}}, \code{\link{m_rtr}},
  \code{\link{n_rtr}}, \code{\link{pad}},
  \code{\link{patologiavdelning}}, \code{\link{region}},
  \code{\link{sida}}, \code{\link{sjukhus}},
  \code{\link{sjukvardsomrade}}, \code{\link{snomed3}},
  \code{\link{snomed}}, \code{\link{t_rtr}},
  \code{\link{tnmgrund}}
}
\keyword{datasets}

