% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.keyvalue.list.R
\name{as.keyvalue.list}
\alias{as.keyvalue.list}
\title{Coerce a list to keyvalue object}
\usage{
\method{as.keyvalue}{list}(x, ...)
}
\arguments{
\item{x}{a \code{list} with properties described in the details section.}

\item{...}{further arguments passed to \code{\link{as.keyvalue}}.}
}
\value{
The function returns an object of class \code{keyvalue} 
(and \code{list}.
}
\description{
\code{x} should be a list with properties descrobed in section "Details".
}
\details{
\itemize{
   \item{All names of the list elements should be unique.}
   \item{All elements of the list should be named.}
   \item{All keys should be unique (a key should only be mappad to 
   one value).}
   \item{All elements of the list should be atomic vectors.}
}
}
\examples{

ex <- list(
 fruit  = c("banana", "orange", "kiwi"),
 car    = c("SAAB", "Volvo", "taxi", "truck"),
 animal = c("elefant")
)
as.keyvalue(ex)
is.keyvalue(ex)

\donttest{
# An invalid list (non unique names; not because of silly classification)
ex2 <- list(
 fruit  = c("banana", "orange", "kiwi"),
 car    = c("SAAB", "Volvo", "taxi", "truck"),
 animal = c("elefant"),
 fruit  = c("President_Obama")
)
as.keyvalue(ex2)

# An invalid list (non unique keys; kiwi appear twice)
ex3 <- list(
 fruit  = c("banana", "orange", "kiwi"),
 car    = c("SAAB", "Volvo", "taxi", "truck"),
 animal = c("elefant", "kiwi")
)
as.keyvalue(ex3)
}
}
\seealso{
\link{as.keyvalue}
}
