% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typocorr.R
\docType{methods}
\name{correct_typos}
\alias{correct_typos}
\alias{correct_typos,data.frame,validator-method}
\title{Correct typos in restricted numeric data}
\usage{
correct_typos(dat, x, ...)

\S4method{correct_typos}{data.frame,validator}(dat, x, fixate = NULL,
  eps = 1e-08, maxdist = 1, ...)
}
\arguments{
\item{dat}{An R object holding numeric (integer) data.}

\item{x}{An R object holding linear data validation rules}

\item{...}{Options to be passed to \code{\link[stringdist]{stringdist}}
which is used to determine the typographic distance between the original
value and candidate solutions. By default, the optimal string alignment distance
is used, with all weights equal to one.}

\item{fixate}{\code{[character]} vector of variable names that may not be changed}

\item{eps}{\code{[numeric]} maximum roundoff error}

\item{maxdist}{\code{[numeric]} maximum allowd typographical distance}
}
\value{
\code{dat}, with values corrected.
}
\description{
Attempt to fix violations of linear (in)equality restrictions imposed on a
record by replacing values with values that differ from the original values
by typographical errors.
}
\section{Details}{


The algorithm works by proposing candidate replacement values and checking
whether they are likely to be the result of a typographical error. A value is
accepted as a solution when it resolves at least one equality violation. An
equality restriction \code{a.x=b} is considered satisfied when
\code{abs(a.x-b)<eps}. Setting \code{eps} to one or two units of measurement
allows for robust typographical error detection in the presence of 
roundoff-errors.

The algorithm is meant to be used on numeric data representing integers.
}
\examples{
library(validate)

# example from section 4 in Scholtus (2009)

v <-validate::validator( 
   x1 + x2 == x3
 , x2 == x4
 , x5 + x6 + x7 == x8
 , x3 + x8 == x9
 , x9 - x10 == x11
 )
 

dat <- read.csv(textConnection(
"x1, x2 , x3  , x4 , x5 , x6, x7, x8 , x9   , x10 , x11
1452, 116, 1568, 116, 323, 76, 12, 411,  1979, 1842, 137
1452, 116, 1568, 161, 323, 76, 12, 411,  1979, 1842, 137
1452, 116, 1568, 161, 323, 76, 12, 411, 19979, 1842, 137
1452, 116, 1568, 161,   0,  0,  0, 411, 19979, 1842, 137
1452, 116, 1568, 161, 323, 76, 12,   0, 19979, 1842, 137"
))
cor <- correct_typos(dat,v)
dat - cor




}
\references{
\itemize{
\item{The first version of the algorithm was described by S. Scholtus (2009). Automatic
correction of simple typing errors in numerical data with balance edits. Statistics 
Netherlands, Discussion Paper \href{https://www.cbs.nl/nl-nl/achtergrond/2009/48/automatic-correction-of-simple-typing-errors-in-numerical-data-with-balance-edits}{09046}
}
\item{The generalized version of this algorithm that is implemented for this package is
described in M. van der Loo, E. de Jonge and S. Scholtus (2011). Correction of rounding, typing and sign errors with the deducorrect package.
Statistics Netherlands, Discussion Paper \href{https://www.cbs.nl/nl-nl/achtergrond/2011/51/deductive-imputation-with-the-deducorrect-package}{2011019}
}
}
}

