% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mou_EM.R
\name{mou_EM}
\alias{mou_EM}
\title{Mixture of Unigrams by Expectation-Maximization algorithm}
\usage{
mou_EM(x, k, n_it = 100, eps = 1e-07, seed_choice = 1, init = NULL)
}
\arguments{
\item{x}{Document-term matrix describing the frequency of terms that occur in a collection of documents. Rows correspond to documents in the collection and columns correspond to terms.}

\item{k}{Number of clusters/groups.}

\item{n_it}{Number of iterations for the Expectation-Maximization algorithm.}

\item{eps}{Tolerance level for the convergence of the algorithm. Default is \code{1e-07}.}

\item{seed_choice}{Set seed for reproducible results}

\item{init}{Vector containing the initial document allocations for the initialization of the algorithm. If \proglang{NULL} (default) initialization is carried out via spherical k-means (\link[skmeans]{skmeans}).}
}
\value{
A list containing the following elements:
\item{x}{The data matrix.}
\item{clusters}{the clustering labels.}
\item{k}{the number of clusters.}
\item{numobs}{the sample size.}
\item{p}{the vocabulary size.}
\item{likelihood}{vector containing the likelihood values at each iteration.}
\item{pi_hat}{estimated probabilities of belonging to the \code{k} clusters.}
\item{omega}{matrix containing the estimates of the omega parameters for each cluster.}
\item{f_z_x}{matrix containing the posterior probabilities of belonging to each cluster.}
\item{AIC}{Akaike Information Criterion (AIC) value of the fitted model.}
\item{BIC}{Bayesian Information Criterion (BIC) value of the fitted model.}
}
\description{
Performs parameter estimation by means of the Expectation-Maximization (EM) algorithm and cluster allocation
for the Mixture of Unigrams.
}
\details{
Starting from the data given by \code{x} the Mixture of Unigrams is fitted
and \code{k} clusters are obtained.
The algorithm for the parameter estimation is the Expectation-Maximization (EM).
In particular, the function assigns initial values to weights of the Multinomial distribution for each cluster
and inital weights for the components of the mixture. The estimates are obtained with maximum \code{n_it} steps of the
EM algorithm or until the tolerance level \code{eps} is reached; by using the posterior distribution
of the latent variable z, the documents are allocated to the cluster which maximizes the
posterior distribution.
For further details see the references.
}
\examples{
# Load the CNAE2 dataset
data("CNAE2")

# Perform parameter estimation and clustering
mou_CNAE2 = mou_EM(x = CNAE2, k = 2)

# Shows cluster labels to documents
mou_CNAE2$clusters

}
\references{
Nigam, K., McCallum, A., Thrun, S., Mitchell, T.: Text classification from labeled and unlabeled documents using EM. Machine learning 39, 103-134 (2000).
}
