% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLP.R
\name{backpropagation_MLP}
\alias{backpropagation_MLP}
\title{backpropagation_MLP function}
\usage{
backpropagation_MLP(MLPNet, loss, truth)
}
\arguments{
\item{MLPNet}{output from the function MLP_net, as applied to some data with given parameters}

\item{loss}{the loss function, see ?Qloss and ?multinomial}

\item{truth}{the truth, a list of vectors to compare with output from the feed-forward network}
}
\value{
a list object containing the cost and the gradient with respect to each of the model parameters
}
\description{
A function to perform backpropagation for a multilayer perceptron.
}
\references{
\enumerate{
    \item Ian Goodfellow, Yoshua Bengio, Aaron Courville, Francis Bach. Deep Learning. (2016)
    \item Terrence J. Sejnowski. The Deep Learning Revolution (The MIT Press). (2018)
    \item Neural Networks YouTube playlist by 3brown1blue: \url{https://www.youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi}
    \item{http://neuralnetworksanddeeplearning.com/}
}
}
\seealso{
\link{network}, \link{train}, \link{backprop_evaluate}, \link{MLP_net}, \link{backpropagation_MLP},
\link{logistic}, \link{ReLU}, \link{smoothReLU}, \link{ident}, \link{softmax}, \link{Qloss}, \link{multinomial},
\link{NNgrad_test}, \link{weights2list}, \link{bias2list}, \link{biasInit}, \link{memInit}, \link{gradInit},
\link{addGrad}, \link{nnetpar}, \link{nbiaspar}, \link{addList}, \link{no_regularisation}, \link{L1_regularisation},
\link{L2_regularisation}
}
