% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepspat_main_trivar_GP.R
\name{deepspat_trivar_GP}
\alias{deepspat_trivar_GP}
\title{Deep trivariate compositional spatial model}
\usage{
deepspat_trivar_GP(
  f,
  data,
  g = ~1,
  layers_asym_2 = NULL,
  layers_asym_3 = NULL,
  layers = NULL,
  method = c("REML"),
  family = c("matern_stat_symm", "matern_stat_asymm", "matern_nonstat_symm",
    "matern_nonstat_asymm"),
  par_init = initvars(),
  learn_rates = init_learn_rates(),
  nsteps = 150L
)
}
\arguments{
\item{f}{formula identifying the dependent variables and the spatial inputs in the covariance}

\item{data}{data frame containing the required data}

\item{g}{formula identifying the independent variables in the linear trend}

\item{layers_asym_2}{list containing the aligning function layers for the second process}

\item{layers_asym_3}{list containing the aligning function layers for the third process}

\item{layers}{list containing the nonstationary warping layers}

\item{method}{identifying the method for finding the estimates}

\item{family}{identifying the family of the model constructed}

\item{par_init}{list of initial parameter values. Call the function \code{initvars()} to see the structure of the list}

\item{learn_rates}{learning rates for the various quantities in the model. Call the function \code{init_learn_rates()} to see the structure of the list}

\item{nsteps}{number of steps when doing gradient descent times two, three or five (depending on the family of model)}
}
\value{
\code{deepspat_trivar_GP} returns an object of class \code{deepspat_trivar_GP} with the following items
\describe{
 \item{"f"}{The formula used to construct the covariance model}
 \item{"g"}{The formula used to construct the linear trend model}
 \item{"data"}{The data used to construct the deepspat model}
 \item{"X"}{The model matrix of the linear trend}
 \item{"layers"}{The warping function layers in the model}
 \item{"layers_asym_2"}{The aligning function layers for the second process in the model}
 \item{"layers_asym_3"}{The aligning function layers for the third process in the model}
 \item{"Cost"}{The final value of the cost}
 \item{"eta_tf"}{Estimated weights in the warping layers as a list of \code{TensorFlow} objects}
 \item{"eta_tf_asym_2"}{Estimated weights in the aligning layers for the second process as a list of \code{TensorFlow} objects}
 \item{"eta_tf_asym_3"}{Estimated weights in the aligning layers for the third process as a list of \code{TensorFlow} objects}
 \item{"beta"}{Estimated coefficients of the linear trend}
 \item{"precy_tf1"}{Precision of measurement error of the first process, as a \code{TensorFlow} object}
 \item{"precy_tf2"}{Precision of measurement error of the second process, as a \code{TensorFlow} object}
 \item{"precy_tf3"}{Precision of measurement error of the third process, as a \code{TensorFlow} object}
 \item{"sigma2_tf_1"}{Variance parameter (first process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"sigma2_tf_2"}{Variance parameter (second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"sigma2_tf_3"}{Variance parameter (third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"sigma2_tf_12"}{Covariance parameter (between first and second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"sigma2_tf_13"}{Covariance parameter (between first and third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"sigma2_tf_23"}{Covariance parameter (between second and third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf1"}{Length scale parameter (first process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf2"}{Length scale parameter (second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf3"}{Length scale parameter (third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf12"}{Length scale parameter (cross-covariance between first and second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf13"}{Length scale parameter (cross-covariance between first and third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf23"}{Length scale parameter (cross-covariance between second and third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf1"}{Smoothness parameter (first process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf2"}{Smoothness parameter (second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf3"}{Smoothness parameter (third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf12"}{Smoothness parameter (cross-covariance between first and second process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf13"}{Smoothness parameter (cross-covariance between first and third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"nu_tf23"}{Smoothness parameter (cross-covariance between second and third process) in the covariance matrix, as a \code{TensorFlow} object}
 \item{"scalings"}{Minima and maxima used to scale the unscaled unit outputs for each warping layer, as a list of \code{TensorFlow} objects}
 \item{"scalings_asym"}{Minima and maxima used to scale the unscaled unit outputs for each aligning layer, as a list of \code{TensorFlow} objects}
 \item{"method"}{Method used for inference}
 \item{"nlayers"}{Number of warping layers in the model}
 \item{"nlayers_asym"}{Number of aligning layers in the model}
 \item{"run"}{\code{TensorFlow} session for evaluating the \code{TensorFlow} objects}
 \item{"swarped_tf1"}{Spatial locations of the first process on the warped domain}
 \item{"swarped_tf2"}{Spatial locations of the second process on the warped domain}
 \item{"swarped_tf3"}{Spatial locations of the third process on the warped domain}
 \item{"negcost"}{Vector of costs after each gradient-descent evaluation}
 \item{"z_tf_1"}{Data of the first process}
 \item{"z_tf_2"}{Data of the second process}
 \item{"z_tf_3"}{Data of the third process}
 \item{"family"}{Family of the model}
 }
}
\description{
Constructs a deep trivariate compositional spatial model
}
