% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delim_join.R
\name{delim_join}
\alias{delim_join}
\title{Join Multiple Species Delimitation Methods Outputs}
\usage{
delim_join(delim)
}
\arguments{
\item{delim}{A \link[base:list]{list} or \link[base:data.frame]{data.frame} of multiple
species delimitation methods outputs.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{delim_join()} returns a \link[tibble:tbl_df-class]{tbl_df} of species delimitation
outputs whose partitions are consistent across different methods.
}
\details{
\code{delim_join()} is a helper function to join multiple lists or columns of species
delimitation outputs into a single \link[tibble:tbl_df-class]{tbl_df} while keeping consistent
identifications across multiple methods. Species delimitation outputs are in general a
list or data frame of sample labels and its species partitions (Species 1, Species 2, etc.). These
partition names may be or not the same across two or more methods. \code{delim_join()} standardizes
partition names across two or more species delimitation outputs while keeping its underlying structure intact.
}
\examples{

\donttest{
## run GMYC
gmyc_res <- splits::gmyc(ape::as.phylo(geophagus_beast), method = "single")

# create a tibble
gmyc_df <- gmyc_tbl(gmyc_res)

## run bGMYC
bgmyc_res <- bGMYC::bgmyc.singlephy(ape::as.phylo(geophagus_beast),
  mcmc = 11000,
  burnin = 1000,
  thinning = 100,
  t1 = 2,
  t2 = ape::Ntip(ape::as.phylo(geophagus_beast)),
  start = c(1, 0.5, 50)
)

# create a tibble
bgmyc_df <- bgmyc_tbl(bgmyc_res, ppcutoff = 0.05)

## LocMin

# create a distance matrix
mat <- ape::dist.dna(geophagus, model = "raw", pairwise.deletion = TRUE)

# estimate local minima from `mat`
locmin_res <- spider::localMinima(mat)

# create a tibble
locmin_df <- locmin_tbl(mat,
  threshold = locmin_res$localMinima[1],
  haps = ape::as.phylo(geophagus_beast)$tip.label
)

# join delimitations
all_delims <- delim_join(list(gmyc_df, bgmyc_df, locmin_df))

# check
all_delims

}

}
\author{
Pedro S. Bittencourt, Rupert A. Collins.
}
