% Generated by roxygen2 (4.0.2): do not edit by hand
\name{DendSer.dendrogram}
\alias{DendSer.dendrogram}
\title{Tries to run DendSer on a dendrogram}
\usage{
DendSer.dendrogram(dend, ser_weight, ...)
}
\arguments{
\item{dend}{An object of class dendrogram}

\item{ser_weight}{Used by cost function to evaluate
 ordering. For cost=costLS, this is a vector of
  object weights. Otherwise is a dist or symmetric matrix.
passed to DendSer.
If it is missing, the cophenetic distance is used instead.}

\item{...}{parameters passed to \link[DendSer]{DendSer}}
}
\value{
Numeric vector giving an optimal dendrogram order
}
\description{
Implements dendrogram seriation.
The function tries to turn the dend into hclust, on
which it runs \link[DendSer]{DendSer}.

Also, if a distance matrix is missing, it will try
to use the \link{cophenetic} distance.
}
\examples{
\dontrun{
library(DendSer) # already used from within the function
hc <- hclust(dist(USArrests[1:4,]), "ave")
dend <- as.dendrogram(hc)
DendSer.dendrogram(dend)
}
}
\seealso{
\code{\link[DendSer]{DendSer}}, \link{DendSer.dendrogram} ,
\link{untangle_DendSer}, \link{rotate_DendSer}
}

