% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvclust.R
\name{pvclust_show_signif}
\alias{pvclust_show_signif}
\title{The significant branches in a dendrogram, based on a pvclust object}
\usage{
pvclust_show_signif(dend, pvclust_obj, signif_type = c("bp", "au"),
  alpha = 0.05, signif_value = c(5, 1), show_type = c("lwd", "col"), ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{pvclust_obj}{a pvclust object}

\item{signif_type}{a character scalar (either "bp" or "au"), indicating
which of the two should be used to update the dendrogram.}

\item{alpha}{a number between 0 to 1, default is .05. Indicates what is the
cutoff from which branches will be updated.}

\item{signif_value}{a 2d vector (deafult: c(5,1)),
with the first element tells us what the significant branches will get,
and the second element which value the non-significant branches will get.}

\item{show_type}{a character scalar (either "lwd" or "col"), indicating
which parameter of the branches should be updated based on significance.}

\item{...}{not used}
}
\value{
A dendrogram with updated branches
}
\description{
Shows the significant branches in a dendrogram, based on a pvclust object
}
\examples{
\dontrun{
library(pvclust)
data(lung) # 916 genes for 73 subjects
set.seed(13134)
result <- pvclust(lung[, 1:20], method.dist="cor", method.hclust="average", nboot=100)

dend <- as.dendrogram(result)
result \%>\% as.dendrogram \%>\% 
   hang.dendrogram \%>\%
   plot(main = "Cluster dendrogram with AU/BP values (\%)")
result \%>\% text
result \%>\% pvrect(alpha=0.95)

dend \%>\% pvclust_show_signif(result) \%>\% plot
dend \%>\% pvclust_show_signif(result, show_type = "lwd") \%>\% plot
result \%>\% text
result \%>\% pvrect(alpha=0.95)

dend \%>\% pvclust_show_signif_gradient(result) \%>\% plot

dend \%>\% 
   pvclust_show_signif_gradient(result) \%>\% 
   pvclust_show_signif(result) \%>\%
   plot(main = "Cluster dendrogram with AU/BP values (\%)\\n bp values are highlighted by signif")
result \%>\% text
result \%>\% pvrect(alpha=0.95)
}
}
\seealso{
\link{pvclust_show_signif}, \link{pvclust_show_signif_gradient}
}
