#' Monthly mean air temperatures for dataset swit272 from 2018 - 1950
#'
#' Monthly mean temperature (Celsius) downloaded from KNMI Climate explorer.
#' Row names are given as years. Data was downloaded as daily fields and
#' later transformed into monthly. Source: E-OBS 1950-now 0.25°.
#' This is gridded data for the grid point: lon = 9.875, lat = 46.375.
#'
#' @format A data frame with 69 rows and 12 variables:
#' \describe{
#'   \item{Jan}{Mean monthly air temperature for January from 1950 to 2018}
#'   \item{Feb}{Mean monthly air temperature for February from 1950 to 2018}
#'   \item{Mar}{Mean monthly air temperature for March from 1950 to 2018}
#'   \item{Apr}{Mean monthly air temperature for April from 1950 to 2018}
#'   \item{May}{Mean monthly air temperature for May from 1950 to 2018}
#'   \item{Jun}{Mean monthly air temperature for June from 1950 to 2018}
#'   \item{Jul}{Mean monthly air temperature for July from 1950 to 2018}
#'   \item{Aug}{Mean monthly air temperature for August from 1950 to 2018}
#'   \item{Sep}{Mean monthly air temperature for September from 1950 to 2018}
#'   \item{Oct}{Mean monthly air temperature for October from 1950 to 2018}
#'   \item{Nov}{Mean monthly air temperature for November from 1950 to 2018}
#'   \item{Dec}{Mean monthly air temperature for December from 1950 to 2018}
#' }
#' @source \url{https://climexp.knmi.nl/}
#'
#' @details We acknowledge the E-OBS dataset from the EU-FP6 project UERRA (http://www.uerra.eu) and the Copernicus Climate Change Service, and the data providers in the ECA&D project (https://www.ecad.eu). Cornes, R., G. van der Schrier, E.J.M. van den Besselaar, and P.D. Jones. 2018: An Ensemble Version of the E-OBS Temperature and Precipitation Datasets, J. Geophys. Res. Atmos., 123. doi:10.1029/2017JD028200
#'
#' @export
"swit272_monthly_temperatures"
