% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{basal_i}
\alias{basal_i}
\alias{basal2dbh}
\title{Individual basal area}
\usage{
basal2dbh(basal)

basal_i(dbh, circum = NULL)
}
\arguments{
\item{dbh}{numeric vector of diameter.}

\item{circum}{numeric vector of circumference. Is used only when \code{dbh}
is not given.}

\item{basal}{numeric, individual basal area.}
}
\value{
\code{basal_i} returns individual basal area while \code{basal2dbh} returns DBH.
}
\description{
The area of a circle of diameter \code{dbh}.
}
\details{
If \code{circum} is given, \code{dbh} is not used.
}
\examples{
basal_i(dbh = 10)
basal_i(circum = 31.41)
basal2dbh(78.53982)
}
