% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoundingCovariateEffects.R
\name{G.cd.mc}
\alias{G.cd.mc}
\title{Family of discrete/continuous instrumental functions, in the case of
many covariates.}
\usage{
G.cd.mc(
  x,
  g.idx,
  data,
  n.if.per.cov,
  idxs.c,
  G.c,
  norm.func,
  info.manycov = NULL,
  cov.ranges = NULL,
  norm.cov.out = NULL,
  degree = 3,
  ...
)
}
\arguments{
\item{x}{The vector of covariates at which to evaluate the B-splines}

\item{g.idx}{The index of the instrumental function.}

\item{data}{Data frame containing the data.}

\item{n.if.per.cov}{Number of instrumental functions per continuous covariate.}

\item{idxs.c}{Vector of indices of the continuous elements in the vector of
covariates.}

\item{G.c}{Family of instrumental functions to use for the subvector of
continuous covariates.}

\item{norm.func}{Function to be used to normalize the covariates.}

\item{info.manycov}{Data frame containing some information about the global
structure of the instrumental functions of this class. If
\code{info.manycov = NULL}, it will be computed during execution. Default is
\code{info.manycov = NULL}.}

\item{cov.ranges}{Matrix containing as its rows the lower and upper bounds
for each continuous covariate. Default is \code{cov.ranges = NULL}.}

\item{norm.cov.out}{Output of function that normalizes the covariates.}

\item{degree}{Degree of the spline functions to be used as instrumental
functions for the continuous covariates (if applicable). Default is
\code{degree = 3}.}

\item{...}{Arguments specified here will be ignored. Used for compatibility
with other instrumental function classes.}
}
\description{
This function defines the family of discrete/continuous
instrumental functions in the case of many covariates. It does so by
considering a instrumental functions for each pair of entries in the given
covariate vector.
}
