\name{ols.infocrit}
\alias{ols.infocrit}
\title{Calculate Common Information Criteria}
\usage{
ols.infocrit(mod, which = "all", scaled = FALSE)
}
\arguments{
\item{mod}{linear model object generated by \code{ols()}.}

\item{which}{string value specifying the type of criterion: \code{"aic"} (Akaike Information Criterion), \code{"sic"} (Schwarz Information Criterion), or \code{"pc"}, (Prognostic Criterion), optional, if omitted then all criteria are returned (\code{"all"}).}

\item{scaled}{logical value which indicates whether criteria should be scaled by the number of observations T.}
}
\value{
A data frame of AIC, SIC, and PC values.
}
\description{
Calculates three common information criteria of models estimated by \code{ols()}.
}
\examples{
wage.est <- ols(wage ~ educ + age, data = data.wage)
ols.infocrit(wage.est) # Return all criteria unscaled
ols.infocrit(wage.est, scaled = TRUE) # Return all criteria scaled
ols.infocrit(wage.est, which = "pc") # Return Prognostic Criterion unscaled

}
\concept{Akaike Information Criterion}
\concept{Prognostic Criterion}
\concept{Schwarz Criterion}
