% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_ViolinRuns}
\alias{plot_ViolinRuns}
\title{Violin plot of run length per individual (either sum or mean)}
\usage{
plot_ViolinRuns(runs, method = c("sum", "mean"), outputName = NULL,
  plotTitle = NULL, savePlots = FALSE)
}
\arguments{
\item{runs}{a data.frame with runs per individual (group, id, chrom, nSNP, start, end, length)}

\item{method}{"sum" or "mean" of run lengths per individual samples}

\item{outputName}{title prefix (the base name of graph, if savePlots is TRUE)}

\item{plotTitle}{title in plot (default NULL)}

\item{savePlots}{should plots be saved out to files or plotted in the graphical terminal (default)?}
}
\value{
Violin plot of the distribution of runs-lengths (sum or mean)
}
\description{
Function to produce violin plots of the distribution of runs lengths per group
The sum of run lengths, or its average, per individual sample is used to
characterize the distribution of runs
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

plot_ViolinRuns(runs = runsDF, method = "sum" , savePlots = FALSE)
plot_ViolinRuns(runs = runsDF, method = "mean" , savePlots = FALSE)

}
