% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_slice.R
\name{show_slice}
\alias{show_slice}
\title{2D and 3D Slice Display for Tours}
\usage{
show_slice(
  x,
  ...,
  palette = viridis,
  center = TRUE,
  axes = TRUE,
  edges = NULL,
  paused = TRUE,
  scale_factor = NULL,
  slice_relative_volume = 0.1,
  anchor = NULL
)
}
\arguments{
\item{x}{a \code{detour} object}

\item{...}{used to support aesthetic parameters for the plot, including
\itemize{
\item size: point size, defaults to 1
\item alpha: point opacity, defaults to 1
\item background_colour: defaults to "white"
}}

\item{palette}{Colour palette to use with the colour aesthetic. Can be:
\itemize{
\item A character vector of R colours. This should match the number of levels
of the colour aesthetic, or the number of bins to use for continuous colours.
\item A function which takes the number of colours to use as input and returns a
character vector of colour names and / or hex values as output.
}}

\item{center}{If TRUE, center the projected data to (0, 0, 0).}

\item{axes}{Can be one of:
\itemize{
\item \code{TRUE} draw axes and use column names for axis labels
\item \code{FALSE} do not draw axes or labels
\item \code{NULL} draw axes with no labels
\item An unnamed vector of labels with the same length as \code{cols}
\item A named vector in the form \code{c("h" = "head")}, where \code{head} is renamed to
\code{h}
}}

\item{edges}{A two column numeric matrix giving indices of ends of lines.}

\item{paused}{whether the widget should be initialised in the 'paused' state}

\item{scale_factor}{used as a multiplier for the point coordinates so they
are displayed on a sensible range. Defaults to the reciprocal of maximum distance
from a point to the origin.}

\item{slice_relative_volume}{number default 0.1. Controls the relative
volume of the slice and thus the number of points which are highlighted.
This is an approximate value and is only accurate for values << 1}

\item{anchor}{anchor vector of length p to offset the projection plane
when calculating the distance from each point to the projection plane.}
}
\value{
An object of class \code{htmlwidget}
}
\description{
An implementation of the Slice Tour described in Laa et al., 2020. Points
close to the projection plane are highlighted, and those far away are
faded out.
}
\details{
This display method produces an interactive scatterplot animation which
supports both 2D and 3D tours. Linked selection and filtering is also
supported using {crosstalk}. The set of interactive controls available are:
\itemize{
\item A timeline with a play / pause button and indicators at the position of
each basis used. The basis indicators can be hovered with the mouse to show
the index of the basis, or clicked to jump to that basis. The timeline
also allows for clicking and dragging of the scrubber to move to any
individual frame of the animation.
\item Orbit controls. For the 2D variant, this allows the projection to be
rotated by clicking and dragging from left to right. For the 3D variant,
full orbit controls are available by clicking and dragging. For both orbit
and pan controls, the scroll wheel can be used to zoom.
\item Pan controls, which work similarly to orbit controls but move the camera
laterally / vertically rather than rotating
\item Resetting of the orbit and pan controls
\item Selection and highlighting. Multiple selection is possible by using the
shift key
\item Colouring / brushing of highlighted points
}
}
\examples{
x <- geozoo::torus(p = 4, n = 10000)$points |>
  tibble::as_tibble(.name_repair = "unique")

detour(x, tour_aes(projection = everything())) |>
  tour_path(grand_tour(2)) |>
  show_slice(slice_relative_volume = 0.1)
}
\references{
Laa, U., Cook, D., & Valencia, G. (2020). A slice tour for finding
hollowness in high-dimensional data. Journal of Computational and
Graphical Statistics, 29(3), 681-687.
}
\seealso{
show_scatter
}
