% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp_data.R
\name{get_resp_data}
\alias{get_resp_data}
\alias{get_resp_matrix}
\title{Functions for developers}
\usage{
get_resp_data(
  dataSrc,
  qtpredicate = NULL,
  extra_columns = NULL,
  summarised = FALSE,
  env = NULL,
  protect_x = TRUE,
  retain_person_id = TRUE,
  merge_within_persons = FALSE,
  parms_check = NULL,
  raw = FALSE
)

get_resp_matrix(dataSrc, qtpredicate = NULL, env = NULL)
}
\arguments{
\item{dataSrc}{data.frame, integer matrix, dexter database or `dx_resp_data` object}

\item{qtpredicate}{quoted predicate, e.g. \code{quote(booklet_id=='bk01')}}

\item{extra_columns}{to be returned in addition to person_id, booklet_id, item_score, item_id}

\item{summarised}{if TRUE, no item scores are returned, just booklet scores}

\item{env}{environment for evaluation of qtpredicate, defaults to caller environment}

\item{protect_x}{best set TRUE (default)}

\item{retain_person_id}{whether to retain the original person_id levels or just use arbitrary integers}

\item{merge_within_persons}{merge different booklets for the same person together}

\item{parms_check}{data.frame of item_id, item_score to check for coverage of data}

\item{raw}{if raw is TRUE, no sum scores, booklets, or design is provided and arguments, 'parms_check' and 'summarised' are ignored}
}
\value{
\describe{
\item{get_resp_data}{ returns a list with class `dx_resp_data` with elements
\describe{
\item{x}{
when summarised is FALSE, a tibble(person_id, booklet_id, item_id, item_score, booklet_score [, extra_columns]), sorted in such a way that
  all rows pertaining to the same person-booklet are together
  
when summarised is TRUE, a tibble(person_id, booklet_id, booklet_score [, extra_columns])}
\item{design}{
  tibble(booklet_id, item_id), sorted
  }}}

\item{get_resp_matrix}{returns a matrix of item scores as commonly used in other IRT packages, facilitating
easy connection of your own package to the data management capabilities of dexter}
}
}
\description{
These functions are meant for people who want to develop their own models based
on the data management structure of dexter. The benefit is some extra speed and less memory usage 
compared to using \code{get_responses} or \code{get_testscores}.
The return value of get_resp_data can be used as the 'dataSrc' argument in analysis functions.
}
\details{
Regular users are advised not to use these functions 
as incorrect use can crash your R-session or lead to unexpected results.
}
