% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{add_response_data_mst}
\alias{add_response_data_mst}
\alias{add_booklet_mst}
\title{Add multistage response data}
\usage{
add_response_data_mst(db, rsp_data, auto_add_unknown_rules = FALSE)

add_booklet_mst(
  db,
  booklet_data,
  test_id,
  booklet_id,
  auto_add_unknown_rules = FALSE
)
}
\arguments{
\item{db}{a dextermst db handle}

\item{rsp_data}{data.frame with columns (person_id, test_id, booklet_id, item_id, response)}

\item{auto_add_unknown_rules}{if FALSE, unknown responses (i.e. not defined in the scoring rules) will 
generate an error and the function will abort. If TRUE unknown responses will be automatically added to 
the scoring rules with a score of 0}

\item{booklet_data}{data.frame with a column person_id and other columns which names correspond to item_id's}

\item{test_id}{id of a test known in the database}

\item{booklet_id}{id of a booklet known in the database}
}
\description{
Multistage response data can be entered in long format for one or multiple booklets simultaneously
or in wide format one booklet at a time.
}
\details{
Users familiar with dexter might expect to be able to enter new booklets here. Because mst tests 
have a more complicated design that cannot be (easily) derived from the data, 
in dexterMST the test designs have to be entered beforehand.
}
\seealso{
\code{\link{create_mst_test}}
}
