\name{MA_estimates}
\alias{MA_estimates}

\title{
Executing the random effect model-based algorithm (REMB).
}

\description{
This function computes the meta-analysis estimates using one of the random effect model-based algorithms.
}

\usage{
MA_estimates(data, sim0, sim1, family = binomial, link = "logit", nAGQ = 1, 
control = glmerControl(optimizer = "bobyqa"))
}

\arguments{
  \item{data}{
a data frame containing the variables named in the formula (i.e. a toxicity data for each patient at each simulation and trial. 
}
  \item{sim0}{
the simulation starting point; defaults to the minimum number of the simulation in the given data frame. 
}
  \item{sim1}{
the simulation ending point; defaults to the maximum number of the simulation in the given data frame.
}
  \item{family}{
a distribution family for the response variable; defaults to binomial distribution. See \code{\link{glm}} and \code{\link{glmer}} for details. 
}
  \item{link}{
a specification for the model link function. This can be a name/expression, a literal character string or a length-one character vector; defaults to logit link function. See \code{\link{glmer}} for details. 
}
  \item{nAGQ}{
an integer scalar - the number of points per axis for evaluating the adaptive Gauss-Hermite approximation to the log-likelihood; defaults to 1, corresponding to the Laplace approximation. Values greater than 1 produce greater accuracy in the evaluation of the log-likelihood at the expense of speed.
}
  \item{control}{
a list (of correct class, resulting from \code{\link{lmerControl}}() or \code{\link{glmerControl}}() respectively) containing control parameters, including the nonlinear optimizer to be used and parameters to be passed through to the nonlinear optimizer, see the *lmerControl* documentation for details.
}
}

\value{
    An object of class "REMB" is returned, consisting of prediction of the probability of toxicity and estimations. Objects generated by MA_estimates contain at least the following components:

    \item{dataTox}{A data frame containing information for each patient at each simulation and trial.}
    \item{sim0}{The simulation starting point; must be numeric.}
    \item{sim1}{The simulation ending point; must be numeric.}
    \item{family}{A distribution family for the response variable; defaults to binomial distribution. See \code{\link{glm}} and \code{\link{glmer}} for details.}
    \item{link}{A specification for the model link function. This can be a name/expression, a literal character string or a length-one character vector; defaults to logit link function. See \code{\link{glmer}} for details.}
    \item{estimates}{A data frame including the predicted toxicity probabilities (column named as "rndpt"), at each simulation, trial and dose, using either the predicted random effect center "mu" (column named as "PredMu"), if it's available, or the value ratio (i.e. # of toxicities / # of subjects) if the corresponding "mu" is not available. Note that, "PredMu" value is equal to "NA" when there is no prediction for it.}
}

\author{
Artemis Toumazi <artemis.toumazi@gmail.com>, Sarah Zohar <sarah.zohar@inserm.fr>, Anand N. Vidyashankar <avidyash@gmu.edu>, Jie Xu <jxu13@gmu.edu> and Moreno Ursino <moreno.ursino@inserm.fr>
}

\seealso{
\code{\link{glimem}}
}

\examples{
  \dontrun{
    ################################################################
    ### Give a toxicity data for each simulation and each trial. ###
    ############ using "Toxdata"" including in package #############
    ################################################################
    
    data("Toxdata")
    dim(Toxdata)
    colnames(Toxdata)
    
    ## NOTE: The toxicity dataset must have the same structure as below. ##
    ## Check it before running the VarWT function! ##
    
    str(Toxdata)
    
    ## Running the MA_estimates function! ##

    test <- MA_estimates(Toxdata, 10, 10, family = binomial, link = "logit", nAGQ = 1, 
    			 control = glmerControl(optimizer = "bobyqa"))
    
    ### You can see the "show" S4 method to present the REMB algorithm's results
    test

    ##################################################
    ## Taking the predicted probability of toxicity ##
    ##################################################
    
    test@estimates
  }
}

