% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nextDose.R
\name{nextDose}
\alias{nextDose}
\title{Next dose determination of a phase I clinical trial.}
\usage{
nextDose(model, y, AUCs, doses, x, theta, options, prob = 0.9,
  betapriors = NULL, thetaL = NULL, p0 = NULL, L = NULL,
  deltaAUC = NULL, CI = TRUE)
}
\arguments{
\item{model}{A character string to specify the selected dose-finding model. See for details \code{\link{dtox}}, \code{\link{pkcov}}, \code{\link{pkcrm}}, \code{\link{pktox}}, \code{\link{pkpop}}, \code{\link{pklogit}}.}

\item{y}{A binary vector of the toxicity outcomes from previous patients; 1 indicates a toxicity, 0 otherwise.}

\item{AUCs}{A vector with the computed AUC values of each patient for pktox, pkcrm, pklogit and pkpop; defaults to NULL.}

\item{doses}{A vector with the doses panel.}

\item{x}{A vector with the dose level assigned to the patients.}

\item{theta}{The toxicity threshold.}

\item{options}{A list with the Stan model's options.}

\item{prob}{The threshold of the posterior probability of toxicity for the stopping rule in the selected model; defaults to 0.9. See for details \code{\link{dtox}}, \code{\link{pkcov}}, \code{\link{pkcrm}}, \code{\link{pktox}}, \code{\link{pkpop}}, \code{\link{pklogit}}.}

\item{betapriors}{A vector with the value for the prior distribution of the regression parameters in the model; defaults to NULL.}

\item{thetaL}{A second threshold of AUC in the \code{\link{pkcrm}} model; defaults to theta in the PKCRM model and NULL for the models \code{\link{dtox}}, \code{\link{pkcov}}, \code{\link{pktox}}, \code{\link{pkpop}} and \code{\link{pklogit}}.}

\item{p0}{The skeleton of CRM for \code{\link{pkcrm}}; defaults to NULL.}

\item{L}{The AUC threshold to be set before starting the trial for \code{\link{pkcrm}}; defaults to NULL.}

\item{deltaAUC}{A vector of the difference between computed individual AUC and the AUC of the population at the same dose level (defined as an average); argument for \code{\link{pkcov}}; defaults to NULL.}

\item{CI}{A logical constant indicating the estimated 95\% credible interval; defaults to TRUE.}
}
\value{
An object of class "dose" is returned, consisting of determination of the next recommended dose and estimations. Objects generated 
by nextDose contain at least the following components:

\item{N}{The total number of enrolled patients.}
\item{y}{A binary vector of toxicity outcomes from previous patients; 1 indicates a toxicity, 0 otherwise.}
\item{AUCs}{A vector with the computed AUC values of each patient.}
\item{doses}{A vector with the doses panel.}
\item{x}{A vector with the dose level assigned to the patients.}
\item{theta}{The tocixity threshold.}
\item{options}{List with the Stan model's options.}
\item{newDose}{The next recommended dose (RD) level; equals to 0 if the trial has stopped, according to the stopping rules.}
\item{pstim}{The mean values of the estimated probabilities of toxicity.}
\item{pstimQ1}{The 1st quartile of the estimated probabilities of toxicity if CI = TRUE, otherwise is NULL.}
\item{pstimQ3}{The 3rd quartile of the estimated probabilities of toxicity if CI = TRUE, otherwise is NULL.}
\item{parameters}{The estimated model's parameters.}
\item{model}{A character string to specify the selected dose-finding model. See for details \code{\link{dtox}}, \code{\link{pkcov}}, \code{\link{pkcrm}}, \code{\link{pktox}}, \code{\link{pkpop}}, \code{\link{pklogit}}.}
}
\description{
nextDose is used to perform parameter estimation at each step during a dose-finding trial. Determines the next or recommended dose level in a phase I clinical trial.
}
\examples{
  \dontrun{
doses <- c(12.59972,34.65492,44.69007,60.80685,83.68946,100.37111)
theta <- 0.2 
options <- list(nchains = 4, niter = 4000, nadapt = 0.9)     
AUCs <- c(1.208339,  5.506040,  6.879835,  3.307928,  3.642430, 
          10.271291,  3.885522,  3.086622,  2.537158,  5.525917,  
          8.522176,  4.642741, 11.048531, 10.246976,  5.226807)
x <- c(1, 2, 3, 4, 5, 6, 4, 4, 4, 5, 5, 4, 4, 5, 5)
y <- c(0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0)
nextD <- nextDose(model = "pktox", y=y, AUCs=AUCs, doses=doses, 
                  x=x, theta=theta, options=options)
}

}
\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal.
}
\seealso{
\code{\link{nsim}}
}
\author{
Artemis Toumazi \email{artemis.toumazi@inserm.fr}, Moreno Ursino \email{moreno.ursino@inserm.fr}, Sarah Zohar \email{sarah.zohar@inserm.fr}
}
