% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn_functions.R
\name{circle.ind}
\alias{circle.ind}
\title{A Helper Function for venn3}
\usage{
circle.ind(ps, x, y, r)
}
\arguments{
\item{ps}{a n x 2 matrix of coordinates.}

\item{x}{the x coordinate of the center of the circle.}

\item{y}{the y coordinate of the center of the circle.}

\item{r}{the radius of the circle.}
}
\value{
a length n vector telling whether each row of ps is inside the given
circle.
}
\description{
Used in venn3 to tell whether proposed points are inside of the given
circle.
}
\examples{



ps <- cbind(runif(100), runif(100))
plot(dga:::circle(0, 0, 1), type = "l")
inds <- dga:::circle.ind(ps, 0, 0, 1)
points(inds)
}
\author{
Kristian Lum \email{kl@hrdag.org}
}
\keyword{circle}
