% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwrapper.R
\name{dgQ2DD_to_Q2DI}
\alias{dgQ2DD_to_Q2DI}
\title{Convert from Q2DD to Q2DI}
\usage{
dgQ2DD_to_Q2DI(dggs, in_quad, in_qx, in_qy)
}
\arguments{
\item{dggs}{A dggs object from dgconstruct()}

\item{in_quad}{Vector of quad numbers}

\item{in_qx}{Vector of quadrant x values}

\item{in_qy}{Vector of quadrant y values}
}
\value{
Returns a dggs object which can be passed to other dggridR
            functions
}
\description{
Uses a discrete global grid system to convert between Q2DD
            and Q2DI (see vignette for details)
}
\examples{
\dontrun{
library(dggridR)
dggs <- dgconstruct(res=20)

dgQ2DD_to_Q2DI(dggs, in_quad, in_qx, in_qy)
}

}
