% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\docType{data}
\name{mtry}
\alias{mtry}
\alias{tree_parameters}
\alias{mtry_long}
\alias{trees}
\alias{min_n}
\alias{sample_size}
\alias{learn_rate}
\alias{loss_reduction}
\alias{tree_depth}
\alias{prune}
\alias{Cp}
\title{Parameter objects related to tree- and rule-based models.}
\format{An object of class \code{quant_param} (inherits from \code{param}) of length 6.}
\usage{
mtry

mtry_long

trees

min_n

sample_size

learn_rate

loss_reduction

tree_depth

prune

Cp
}
\value{
Each object is generated by either \code{new_quant_param} or
\code{new_qual_param}.
}
\description{
These are objects that can be used for modeling, especially in conjunction
with the \pkg{parsnip} package.
}
\details{
These objects are pre-made parameter sets that are useful when the model is
based on trees or rules.
\itemize{
\item \code{mtry} and \code{mtry_long}: The number of predictors that will be randomly
sampled at each split when creating the tree models. The latter uses a
log transformation and is helpful when the data set has a large number of
columns. \code{mtry} is used by \pkg{parsnip}'s \code{parsnip::rand_forest()} function.
\item \code{trees}: The number of trees contained in a random forest or boosted
ensemble. In the latter case, this is equal to the number of boosting
iterations. (see \code{parsnip::rand_forest()} and \code{parsnip::boost_tree()})
functions.
\item \code{min_n}: The minimum number of data points in a node that are required
for the node to be split further. (\code{parsnip::rand_forest()} and
\code{parsnip::boost_tree()})
\item \code{sample_size}: the size of the data set used for modeling within an
iteration of the modeling algorithm, such as stochastic gradient boosting.
(\code{parsnip::boost_tree()})
\item \code{learn_rate}: the rate at which the boosting algorithm adapts from
iteration-to-iteration. (\code{parsnip::boost_tree()})
\item \code{loss_reduction}:  The reduction in the loss function required to split
further. (\code{parsnip::boost_tree()})
\item \code{tree_depth}: The maximum depth of the tree (i.e. number of splits).
(\code{parsnip::boost_tree()})
\item \code{prune}: a logical for whether a tree or set of rules should be pruned.
\item \code{Cp}: The cost-complexity parameter in classical CART models.
}
}
\keyword{datasets}
