% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_stop_iter.R
\name{stop_iter}
\alias{stop_iter}
\title{Early stopping parameter}
\usage{
stop_iter(range = c(3L, 20L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
For some models, the effectiveness of the model can decrease as training
iterations continue. \code{stop_iter()} can be used to tune how many iterations
without an improvement in the objective function occur before training should
be halted.
}
\examples{
stop_iter()
}
