% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_range_limits.R
\name{range_limits}
\alias{range_limits}
\alias{lower_limit}
\alias{upper_limit}
\title{Limits for the range of predictions}
\usage{
lower_limit(range = c(-Inf, Inf), trans = NULL)

upper_limit(range = c(-Inf, Inf), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Range limits truncate model predictions to a specific range of values,
typically to avoid extreme or unrealistic predictions.
}
\examples{
lower_limit()
upper_limit()
}
