% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{min_fnorm}
\alias{min_fnorm}
\title{Minimize Frobenius norm for between two matrices}
\usage{
min_fnorm(A, B = diag(nrow(A)))
}
\arguments{
\item{A}{data matrix we want to permute}

\item{B}{matrix whose distance with the permuted A we want to minimize. By
default, \code{B <- diag(nrow(A))}, so the permutation maximizes the trace of A.}
}
\value{
Permuted matrix such that it is the permutation of A closest to B
}
\description{
Finds a permutation of a matrix such that its Frobenius norm with another
matrix is minimized.
}
\details{
Finds the permutation P of A such that \code{||PA - B||} is minimum in Frobenius
norm. Uses the linear-sum assignment problem (LSAP) solver in the package
\code{clue}. The default B is the identity matrix of same dimension, so that the
permutation of A maximizes its trace. This procedure is useful for
constructing a confusion matrix when we don't know the true class labels of a
predicted class and want to compare to a reference class.
}
\examples{

set.seed(1)
A <- matrix(sample(1:25, size = 25, rep = FALSE), 5, 5)
min_fnorm(A)
}
\author{
Ravi Varadhan:
https://stat.ethz.ch/pipermail/r-help/2010-April/236664.html
}
