% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{dmmn}
\alias{dmmn}
\title{Compute density of multinomial mixture for a matrix}
\usage{
dmmn(x, p, mc, labels = NULL)
}
\arguments{
\item{x}{A sparseMatrix that is a sample by feature matrix of counts.}

\item{p}{Matrix with probability parameters of multinomials for each group.
Number of rows must be same as number of columns in X}

\item{mc}{Numeric vector with mixture coefficients. Length must be same as 
number of columns in \code{p}.}

\item{labels}{Numeric vector of same length as number of rows in x. Fixes 
the group probabilities of the integer in this vector element to 1. In 
other words, the latent variable for these samples are treated as known.}
}
\value{
a numeric matrix with n samples by k groups containing log multinomial 
 densities under the given parameters of the MMM.
}
\description{
Given an n x p matrix of count data \code{x}, as well as a 
p x k matrix of probabilities \code{p}, return the probabilities 
of each sample for the k groups in a n x k matrix. If \code{x} 
has any non-integer values, they are rounded to the nearest integer.
}
