% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difNLR-package.R
\docType{package}
\name{difNLR-package}
\alias{difNLR-package}
\alias{_PACKAGE}
\title{DIF and DDF Detection by Non-Linear Regression Models.}
\description{
The difNLR package containts method for detection of differential item functioning (DIF)
based on non-linear regression. Both uniform and non-uniform DIF effects can be detected when considering
one focal group. The method also allows to test the difference in guessing or inattention parameters
between reference and focal group. DIF detection method is based either on likelihood-ratio test, or on F-test
of submodel. Package also offers method for detection of differential distractor functioning (DDF)
based on multinomial log-linear regression model.
}
\details{
Package: difNLR\cr
Type: Package\cr
Version: 1.2.2\cr
Date: 2018-05-03\cr
Depends: R (>= 3.1), CTT, ggplot2 (>= 2.2.1), methods, msm, nnet, reshape2, stats\cr
License: GPL-3\cr
BugReports: https://github.com/drabinova/difNLR/issues
}
\note{
This package was supported by grant funded by Czech Science foundation under number GJ15-15856Y.
}
\references{
Drabinova, A. & Martinkova P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement, 54(4), 498-517,
\url{https://doi.org/10.1111/jedm.12158}.

Kingston, N., Leary, L., & Wightman, L. (1985). An Exploratory Study of the Applicability of Item Response Theory
Methods to the Graduate Management Admission Test. ETS Research Report Series, 1985(2) : 1-64.

Martinkova, P., Drabinova, A., Liaw, Y. L., Sanders, E. A., McFarland, J. L., & Price, R. M. (2017).
Checking equity: Why Differential Item Functioning Analysis Should Be a Routine Part of Developing Conceptual
Assessments. CBE-Life Sciences Education, 16(2), \url{https://doi.org/10.1187/cbe.16-10-0307}.

Swaminathan, H. & Rogers, H. J. (1990). Detecting Differential Item Functioning Using Logistic Regression Procedures.
Journal of Educational Measurement, 27, 361-370.

Vlckova, K. (2014). Test and Item Fairness (Unpublished master's thesis).
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/drabinova/difNLR/issues}
}

}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
