% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{digitize}
\alias{digitize}
\title{digitize an image}
\usage{
digitize(image_filename, ..., x1, x2, y1, y2)
}
\arguments{
\item{image_filename}{the image file you wish to digitze}

\item{...}{pass parameters col or type to change data calibration points}

\item{x1}{(optional) left-most x-axis point}

\item{x2}{(optional) right-most axis point}

\item{y1}{(optional) the lower y-axis point}

\item{y2}{(optional) the upper y-axis point}
}
\value{
a data.frame containing the digitized data
}
\description{
digitize an image
}
\details{
Proceeds in two steps, both of which require user input
         from the mouse:

           1) Read the image in and calibrate it

           2) Digitize the data

         Calibration points are optionally passed via arguments x1, x2, y1,
         y2. These **must be named in full** if passed.

         If not specified, you are prompted to enter these in the
         console. Note, you don’t need to choose the end points of each axis,
         only two points for which you know the x or y return.
}
\examples{
\dontrun{
tmp <- tempfile()
png(tmp)
plot(rnorm(10) + 1:10, xlab="x", ylab="y")
dev.off()

mydata <- digitize(tmp)
}
}

