% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{BootstrapPCA-class}
\alias{BootstrapPCA-class}
\alias{.BootstrapPCA}
\title{Bootstrap PCA Results}
\description{
An S4 class to store the bootstrap of a principal components analysis.
}
\note{
This class inherits from \code{\linkS4class{PCA}} and \code{\linkS4class{MultivariateBootstrap}}.
}
\examples{
## Bootstrap on CA
## Data from Lebart et al. 2006, p. 170-172
data("colours")

## Compute correspondence analysis
X <- ca(colours)

## Bootstrap (30 replicates)
Y <- bootstrap(X, n = 30)

\dontrun{
## Get replicated coordinates
get_replications(Y, margin = 1)
get_replications(Y, margin = 2)
}

## Plot with ellipses
viz_rows(Y)
viz_tolerance(Y, margin = 1, level = c(0.68, 0.95))

viz_columns(Y)
viz_tolerance(Y, margin = 2, level = c(0.68, 0.95))

## Plot with convex hulls
viz_columns(Y)
viz_hull(Y, margin = 2)

## Bootstrap on PCA
## Compute principal components analysis
data("iris")
X <- pca(iris)

## Bootstrap (30 replicates)
Y <- bootstrap(X, n = 30)

## Plot with ellipses
viz_variables(Y)
viz_tolerance(Y, margin = 2, level = c(0.68, 0.95))
}
\seealso{
Other class: 
\code{\link{BootstrapCA-class}},
\code{\link{CA-class}},
\code{\link{MCA-class}},
\code{\link{MultivariateAnalysis}},
\code{\link{MultivariateBootstrap}},
\code{\link{MultivariateResults}},
\code{\link{MultivariateSummary}},
\code{\link{PCA-class}}
}
\author{
N. Frerebeau
}
\concept{class}
\keyword{internal}
