% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{DINAsim}
\alias{DINAsim}
\title{Simulation Responses from the DINA model}
\usage{
DINAsim(alphas, Q, ss, gs)
}
\arguments{
\item{alphas}{A N by K \code{matrix} of latent attributes.}

\item{Q}{A N by K \code{matrix} indicating which skills are required for which items.}

\item{ss}{A J \code{vector} of item slipping parameters.}

\item{gs}{A J \code{vector} of item guessing parameters.}
}
\value{
A N by J \code{matrix} of responses from the DINA model.
}
\description{
Sample responses from the DINA model for given attribute profiles, Q matrix,
and item parmeters. Returns a \code{matrix} of dichotomous responses
generated under DINA model.
}
\examples{
###########################################
#de la Torre (2009) Simulation Replication
###########################################
N = 200
K = 5
J = 30
delta0 = rep(1,2^K)
    
# Creating Q matrix
Q = matrix(rep(diag(K),2),2*K,K,byrow=TRUE)
for(mm in 2:K){
    temp = combn(1:K,m=mm)
    tempmat = matrix(0,ncol(temp),K)
    for(j in 1:ncol(temp)) tempmat[j,temp[,j]] = 1
    Q = rbind(Q,tempmat)
}
Q = Q[1:J,]
        
# Setting item parameters and generating attribute profiles
ss = gs = rep(.2,J)
PIs = rep(1/(2^K),2^K)
CLs = c((1:(2^K))\\\%*\\\%rmultinom(n=N,size=1,prob=PIs) )
            
# Defining matrix of possible attribute profiles
As = rep(0,K)
for(j in 1:K){
    temp = combn(1:K,m=j)
    tempmat = matrix(0,ncol(temp),K)
    for(j in 1:ncol(temp)) tempmat[j,temp[,j]] = 1
    As = rbind(As,tempmat)
}
As = as.matrix(As)
                    
# Sample true attribute profiles
Alphas = As[CLs,]
                    
# Simulate data under DINA model 
gen = DINAsim(Alphas,Q,ss,gs)
Y_sim = gen$Y
                        
# Execute MCMC
# NOTE: small chain length used to reduce computation time for pedagogical example.
chainLength = 200
burnin = 100
outchain <- DINA_Gibbs(Y_sim, Amat = As, Q, chain_length = chainLength)
                            
# Summarize posterior samples for g and 1-s
mGs = apply(outchain$GamS[,burnin:chainLength],1,mean)
sGs = apply(outchain$GamS[,burnin:chainLength],1,sd)
m1mSS = 1-apply(outchain$SigS[,burnin:chainLength],1,mean)
s1mSS = apply(outchain$SigS[,burnin:chainLength],1,sd)
output=cbind(mGs,sGs,m1mSS,s1mSS)
colnames(output) = c('g Est','g SE','1-s Est','1-s SE')
rownames(output) = paste0('Item ',1:J)
print(output,digits=3)
                                
# Summarize marginal skill distribution using posterior samples for latent class proportions
PIoutput = cbind(apply(outchain$PIs,1,mean),apply(outchain$PIs,1,sd))
colnames(PIoutput) = c('EST','SE')
rownames(PIoutput) = apply(As,1,paste0,collapse='')
print(PIoutput,digits=3)
}
\seealso{
\code{\link{DINA_Gibbs} }
}
\author{
Steven Andrew Culpepper
}
