% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_uncertainty}
\alias{predict_uncertainty}
\title{Function to predict uncertainty from the model result}
\usage{
predict_uncertainty(model_output, newdata = NULL, predict_iid = FALSE,
  N = 100, CI = 0.95)
}
\arguments{
\item{model_output}{fit.result object returned by fit_model function.}

\item{newdata}{If NULL, predictions are made using the data in model_output. 
If this is a raster stack or brick, predictions will be made over this data. Default NULL.}

\item{predict_iid}{If TRUE, any polygon iid effect from the model will be used in the prediction. Default FALSE.}

\item{N}{number of realisations. Default: 100.}

\item{CI}{confidence interval. Default: 0.95.}
}
\value{
The uncertainty_predictions, a list of class \emph{uncertainty}:
  \itemize{
   \item \emph{realisations} RasterStack of realisations of predictions. Number of realisations defined by argument \emph{N}.
   \item \emph{predictions_ci} RasterStack of the upper and lower credible intervals. Defined by argument \emph{CI}.
  }
}
\description{
\emph{predict_uncertainty} function takes a \emph{fit.result} object created by 
\emph{disaggregation::fit_model} and predicts upper and lower credible interval maps.
}
\details{
Function returns a RasterStack of the realisations as well as the upper and lower credible interval rasters.

To predict over a different spatial extent to that used in the model, 
a RasterStack covering the region to make predictions over is passed to the argument \emph{newdata}. 
If this is not given predictions are made over the data used in the fit.

The \emph{predict_iid} logical flag should be set to TRUE if the results of the iid effect from the model are to be used in the prediction.

The number of the realisations and the size of the confidence interval to be calculated.
are given by the arguments \emph{N} and \emph{CI} respectively.
}
\examples{
\dontrun{
predict_uncertainty(result)
}

}
