% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_cluster_utils.R
\name{e_mapa_3D}
\alias{e_mapa_3D}
\title{PCA plot of individuals colored by clusters}
\usage{
e_mapa_3D(pca.model, clusters, colores = NULL, ejes = c(1, 2, 3))
}
\arguments{
\item{pca.model}{an object of class PCA [FactoMineR].}

\item{clusters}{a vector specifying the cluster of each individual.}

\item{colores}{a vector of color for each cluster.}

\item{ejes}{a numeric vector of length 3 specifying the dimensions to be plotted.}
}
\value{
echarts4r plot
}
\description{
PCA plot of individuals colored by clusters
}
\examples{
p <- discoveR:::PCA(iris[, -5], graph = FALSE)
clusters <- factor(kmeans(iris[, -5], 3)$cluster)
e_mapa_3D(p, clusters, c("steelblue", "pink", "forestgreen"))

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
