% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R
\name{summary,market_model-method}
\alias{summary,market_model-method}
\title{Summarizes the model.}
\usage{
\S4method{summary}{market_model}(object)
}
\arguments{
\item{object}{A model object.}
}
\description{
Prints basic information about the passed model object. In addition to the output of
the \code{\link{show}} method, \code{summary} prints
- the number of observations,
- the number of observations in each equation for models with sample separation, and
- various categories of variables.
}
\examples{
\donttest{
simulated_data <- simulate_model_data(
  "diseq_stochastic_adjustment", 500, 3, # model type, observed entities, observed time points
  -0.1, 9.8, c(0.3, -0.2), c(0.6, -0.1), # demand coefficients
  0.1, 5.1, c(0.9), c(-0.5, 0.2), # supply coefficients
  1.2, 3.1, c(0.8) # price equation
)

# initialize the model
model <- new(
  "diseq_stochastic_adjustment", # model type
  c("id", "date"), "date", "Q", "P", # keys, time, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  "Xp1", # price dynamics specification
  simulated_data, # data
  correlated_shocks = TRUE # allow shocks to be correlated
)

# print the model
summary(model)
}
}
