% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icm_function.R
\name{compute_icm_distances}
\alias{compute_icm_distances}
\title{Compute ICM (Integrated Covariance Mahalanobis) Distances}
\usage{
compute_icm_distances(
  data,
  batch_col = NULL,
  mode = c("individual", "intra", "inter", "all"),
  variance_threshold = 0.95,
  center_method_individual = c("global", "batch"),
  center_method_inter = c("mean", "median"),
  ref_batch = NULL
)
}
\arguments{
\item{data}{A data.frame containing numeric variables and optionally a
batch/group column.}

\item{batch_col}{Name of the column representing batch or group (optional).}

\item{mode}{Mode of computation: "individual", "intra", "inter", or "all".}

\item{variance_threshold}{Threshold for cumulative variance to retain in
PCA (default: 0.95).}

\item{center_method_individual}{Method for centering in "individual" mode:
"global" or "batch" (default: "global").}

\item{center_method_inter}{Method for centering in "inter" mode: "mean" or
"median" (default: "mean").}

\item{ref_batch}{Reference batch name to compute inter-batch distances
(default: first batch).}
}
\value{
A list containing data.frames of computed distances depending on the
selected mode(s).
}
\description{
This function computes Mahalanobis distances in PCA-reduced space, with
options for individual, intra-group, and inter-group comparisons. It supports
batch-wise analysis and shrinkage covariance estimation for robustness.
}
\examples{
data <- data.frame(matrix(rnorm(100*5), ncol = 5))
data$Batch <- rep(c("A", "B", "C", "D"), each = 25)
result <- compute_icm_distances(
 data,
 batch_col = "Batch",
 mode = "all",
 center_method_individual = "batch",
 center_method_inter = "mean"
)
print(result)
}
