% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_profile_portion}
\alias{get_profile_portion}
\title{Profile portion determination}
\usage{
get_profile_portion(data, tcol, groups, use_EMA = "yes", bounds = c(1, 85))
}
\arguments{
\item{data}{A data frame with the dissolution profile data in wide format.}

\item{tcol}{A vector of indices specifying the columns in \code{data} that
contain the \% release values. The length of \code{tcol} must be two or
longer.}

\item{groups}{A logical vector specifying different groups.}

\item{use_EMA}{A character string indicating if the similarity factor
\eqn{f_2} should be calculated following the EMA guideline \dQuote{On the
investigation of bioequivalence} (\code{"yes"}, the default) or not
(\code{"no"}). A third option is \code{"ignore"}. If \code{use_EMA} is
\code{"yes"} or \code{"no"} the appropriate profile portion is determined
on the basis of the values of the parameter \code{bounds}. If it is
\code{"ignore"}, the complete profiles are used as specified by the
parameter \code{tcol}.}

\item{bounds}{A numeric vector of the form \code{c(lower, upper)} specifying
the \dQuote{lower} and \dQuote{upper} limits, respectively, for the \%
drug release given that \code{use_EMA} is \code{"no"}. The default is
\code{c(1, 85)}. Mean \% release values of any of the two groups being
compared that are smaller than or equal to the lower bound are ignored and
only the first mean \% release value that is greater than or equal to the
upper bound is included while all the subsequent values are ignored. If
\code{use_EMA} is \code{"yes"} the \code{bounds} are \code{c(1, 85)} per
definition.}
}
\value{
The function returns a logical vector defining the appropriate
profile portion.
}
\description{
The function \code{get_profile_portion()} determines, depending on the value
of \code{use_EMA}, which part of the profile will be used for the similarity
assessment (EMA: European Medicines Agency).
}
\details{
The function \code{get_profile_portion()} determines which part of
a dissolution profile is used for comparison based on the recommendations of
the European Medicines Agency's guideline \dQuote{On the investigation of
bioequivalence}. It says that profile similarity testing and any conclusions
drawn from the results can be considered valid only if the dissolution
profile has been satisfactorily characterised using a sufficient number of
time points. For immediate release formulations comparison at 15 minutes is
essential to know if complete dissolution is reached before gastric emptying.
Where more than 85\% of the drug is dissolved within 15 minutes, dissolution
profiles may be accepted as similar without further mathematical evaluation.
In case more than 85\% is not dissolved at 15 minutes but within 30 minutes,
at least three time points are required: the first time point before 15
minutes, the second at 15 minutes, and the third time point when the release
is close to 85\%. For modified release products, the advice given in the
relevant guidance should be followed. Dissolution similarity may be
determined using the \eqn{f_2} statistic as follows:

\deqn{f_2 = 50 \times \log \left(\frac{100}{\sqrt{1 + \frac{\sum_{t=1}^{n}
  \left(\bar{R}(t) - \bar{T}(t) \right)^2}{n}}} \right) .}{%
  f_2 = 50 log(100 / (sqrt(1 + (sum((R.bar(t) - T.bar(t))^2) / n)))) .}

In this equation
\describe{
  \item{\eqn{f_2}}{is the similarity factor,}
  \item{\eqn{n}}{is the number of time points,}
  \item{\eqn{\bar{R}(t)}{R.bar(t)}}{is the mean percent reference drug
      dissolved at time \eqn{t} after initiation of the study, and}
  \item{\eqn{\bar{T}(t)}{T.bar(t)}}{is the mean percent test drug dissolved
      at time \eqn{t} after initiation of the study.}
}

For both the reference and the test formulations, percent dissolution should
be determined. The evaluation of the similarity factor is based on the
following conditions (called \dQuote{EMA Rules}, from the European Medicines
Agency (EMA) guideline \dQuote{On the investigation of bioequivalence}):
\enumerate{
  \item A minimum of three time points (zero excluded).
  \item The time points should be the same for the two formulations.
  \item Twelve individual values for every time point for each formulation.
  \item Not more than one mean value of > 85\% dissolved for any of the
    formulations.
  \item The relative standard deviation or coefficient of variation of any
    product should be less than 20\% for the first time point and less than
    10\% from the second to the last time point.
}

An \eqn{f_2} value between 50 and 100 suggests that the two dissolution
profiles are similar.
}
\references{
European Medicines Agency (EMA), Committee for Medicinal Products for
Human Use (CHMP). Guideline on the Investigation of Bioequivalence. 2010;
CPMP/EWP/QWP/1401/98 Rev. 1.\cr
\url{https://www.ema.europa.eu/en/documents/scientific-guideline/
guideline-investigation-bioequivalence-rev1_en.pdf}
}
\keyword{internal}
