% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probes.R
\name{add_adapters}
\alias{add_adapters}
\title{Add adapters to probes}
\usage{
add_adapters(
  probe.id.var,
  probe.var,
  ad.len,
  ad.nucl = "t",
  end = c(3, 5),
  mc.cores = 1,
  digits = 4,
  return = "dataframe",
  data,
  data.probe.id.var,
  count.mfe = FALSE,
  RNAfold.path,
  temperature = 40,
  trim.mfe = FALSE,
  MFEmin = 0,
  MFE.files.dir = NULL,
  delete.MFE.files = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{probe.id.var}{vector of probes' identification numbers}

\item{probe.var}{character; character; vector of nucleotide probes}

\item{ad.len}{integer; vector of adapter length}

\item{ad.nucl}{character; vector of adapter nucleotides}

\item{end}{integer; probe's end for adapter attachment. Possible values are 3 and 5.}

\item{mc.cores}{integer; number of processors for parallel computation (not supported on Windows)}

\item{digits}{integer; number of decimal places to round the result (MFE)}

\item{return}{character; returned object; possible values are: \code{"vector"} (vector of nucleotide probes with added adapters),
\code{"dataframe"} (data frame with probes, adapters and their characteristics),
\code{"add"} (user's data frame with added data of probes, adapters and their characteristics)}

\item{data, data.probe.id.var}{user's data frame and it's variable with probes identification numbers (used if \code{return = "add"})}

\item{count.mfe}{logical; count minimum folding energy for probes with adapters}

\item{RNAfold.path, temperature, trim.mfe, MFEmin, MFE.files.dir, delete.MFE.files}{used if \code{count.mfe = TRUE};
see \link{count_MFE}[disprose] for details}

\item{verbose}{logical; show messages}
}
\value{
Vector of nucleotide probes with added adapters, or data frame with probes, adapters and their characteristics,
 or user's data frame with added data of probes, adapters and their characteristics.
}
\description{
Add set of adapters to oligonucleotide probes
}
\details{
\code{ad.len} parameter indicates number of \code{ad.nucl} repeats.
For example, with \code{ad.len =5} for \code{ad.nucl = "t"} adapter will be \code{"ttttt"} and for
\code{ad.nucl = "ac"} adapter will be \code{"acacacacac"}.

\code{ad.len}, \code{ad.nucl} and \code{end} might be vectors of any length.
All possible variants of adapters will be added to probes and tested.

For MFE counting ViennaRNA Package (UNIX or Windows) must be installed. see \link{count_MFE}[disprose] for details
}
\examples{
probes <- data.frame (ids = 1:3,  probes = c ("acacacacacaca", "aaaaagggggtttttccccc",
                                             "atgcgctagctcagc"))
ad.data <- add_adapters(probe.var = probes$probes, probe.id.var = probes$ids,
                       ad.len = c(5, 8), ad.nucl = c("t", "dt"), end = c(3, 5),
                       count.mfe = FALSE, mc.cores = 1, digits = 4,
                       return = "dataframe", data = probes, data.probe.id.var = probes$ids)

}
\author{
Elena N. Filatova
}
