% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fagus_dynamics}
\alias{fagus_dynamics}
\title{Time Series Data from Three Fagus sylvatica Stands}
\format{
data frame with 5 columns and 648 rows.
}
\usage{
data(fagus_dynamics)
}
\description{
A data frame with 648 rows representing enhanced vegetation index, rainfall and temperature in three stands of Fagus sylvatica in Spain, Germany, and Sweden.
}
\details{
Site coordinates for this dataset are in \link{fagus_coordinates}.
}
\examples{
data("fagus_dynamics")

#to time series list
fagus <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
)

#time series plot
if(interactive()){

 tsl_plot(
  tsl = fagus
  )

}

}
\seealso{
Other example_data: 
\code{\link{albatross}},
\code{\link{cities_coordinates}},
\code{\link{cities_temperature}},
\code{\link{covid_counties}},
\code{\link{covid_prevalence}},
\code{\link{eemian_coordinates}},
\code{\link{eemian_pollen}},
\code{\link{fagus_coordinates}},
\code{\link{honeycomb_climate}},
\code{\link{honeycomb_polygons}}
}
\concept{example_data}
\keyword{datasets}
