% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{importance_ls_cpp}
\alias{importance_ls_cpp}
\title{(C++) Contribution of Individual Variables to the Dissimilarity Between Two Aligned Time Series}
\usage{
importance_ls_cpp(x, y, distance = "euclidean")
}
\arguments{
\item{x}{(required, numeric matrix) multivariate time series.}

\item{y}{(required, numeric matrix) multivariate time series
with the same number of columns and rows as 'x'.}

\item{distance}{(optional, character string) distance name from the "names"
column of the dataset \code{distances} (see \code{distances$name}). Default: "euclidean".}
}
\value{
data frame
}
\description{
Computes the contribution of individual variables to the
similarity/dissimilarity between two aligned multivariate time series.
This function generates a data frame with the following columns:
\itemize{
\item variable: name of the individual variable for which the importance
is being computed, from the column names of the arguments \code{x} and \code{y}.
\item psi: global dissimilarity score \code{psi} of the two time series.
\item psi_only_with: dissimilarity between \code{x} and \code{y} computed from the given variable alone.
\item psi_without: dissimilarity between \code{x} and \code{y} computed from all other variables.
\item psi_difference: difference between \code{psi_only_with} and \code{psi_without}.
\item importance: contribution of the variable to the similarity/dissimilarity
between \code{x} and \code{y}, computed as \code{(psi_difference * 100) / psi_all}.
Positive scores represent contribution to dissimilarity,
while negative scores represent contribution to similarity.
}
}
\examples{
#simulate two regular time series
x <- zoo_simulate(
  seed = 1,
  irregular = FALSE
  )

y <- zoo_simulate(
  seed = 2,
  irregular = FALSE
  )

#same number of rows
nrow(x) == nrow(y)

#compute importance
df <- importance_ls_cpp(
  x = x,
  y = y,
  distance = "euclidean"
)

df
}
\seealso{
Other Rcpp_importance: 
\code{\link{importance_dtw_cpp}()},
\code{\link{importance_dtw_legacy_cpp}()}
}
\concept{Rcpp_importance}
