% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/momentum_ls.R
\name{momentum_ls}
\alias{momentum_ls}
\title{Lock-Step Variable Importance Analysis of Multivariate Time Series Lists}
\usage{
momentum_ls(tsl = NULL, distance = "euclidean")
}
\arguments{
\item{tsl}{(required, time series list) list of zoo time series. Default: NULL}

\item{distance}{(optional, character vector) name or abbreviation of the distance method. Valid values are in the columns "names" and "abbreviation" of the dataset \link{distances}. Default: "euclidean".}
}
\value{
data frame:
\itemize{
\item \code{x}: name of the time series \code{x}.
\item \code{y}: name of the time series \code{y}.
\item \code{psi}: psi score of \code{x} and \code{y}.
\item \code{variable}: name of the individual variable.
\item \code{importance}: importance score of the variable.
\item \code{effect}: interpretation of the "importance" column, with the values "increases similarity" and "decreases similarity".
}
}
\description{
Minimalistic but slightly faster version of \code{\link[=momentum]{momentum()}} to compute lock-step importance analysis in multivariate time series lists.
}
\examples{

tsl <- tsl_initialize(
  x = distantia::albatross,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global
  )

df <- momentum_ls(
  tsl = tsl,
  distance = "euclidean"
  )

#focus on important columns
df[, c(
  "x",
  "y",
  "variable",
  "importance",
  "effect"
  )]

}
\seealso{
Other momentum: 
\code{\link{momentum}()},
\code{\link{momentum_dtw}()}
}
\concept{momentum}
