% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distcomp.R
\name{distcompSetup}
\alias{distcompSetup}
\title{Setup a workspace and configuration for a distributed computation}
\usage{
distcompSetup(workspacePath = "", defnPath = paste(workspacePath, "defn",
  sep = .Platform$file.sep), instancePath = paste(workspacePath, "instances",
  sep = .Platform$file.sep), defnFileName = "defn.rds",
  dataFileName = "data.rds", instanceFileName = "instance.rds",
  ssl.verifyhost = TRUE, ssl.verifypeer = TRUE)
}
\arguments{
\item{workspacePath}{a folder specifying the workspace path. This has to be
writable by the opencpu process. On a cloud opencpu server on Ubuntu, for example,
this requires a one-time modification of apparmor profiles to enable write
permissions to this path}

\item{defnPath}{the path where definition files will reside, organized by
computation identifiers}

\item{instancePath}{the path where instance objects will reside}

\item{defnFileName}{the name for the compdef definition files}

\item{dataFileName}{the name for the data files}

\item{instanceFileName}{the name for the instance files}

\item{ssl.verifyhost}{logical value, usually \code{TRUE}, but for testing with
snake-oil certs, one might set this to \code{FALSE}}

\item{ssl.verifypeer}{logical value, usually \code{TRUE}, but for testing with
snake-oil certs, one might set this to \code{FALSE}}
}
\value{
TRUE if all is well
}
\description{
The function \code{discompsetup} sets up a distributed computation
and configures some global parameters such as definition file names,
data file names, instance object file names, and ssl configuration parameters. The
function creates some of necessary subdirectories if not already present and throws
an error if the workspace areas are not writeable
}
\examples{
\dontrun{
distcompSetup(workspacePath="./workspace")
}
}
\seealso{
\code{getConfig}
}

