% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcomp.R
\name{getConfig}
\alias{getConfig}
\title{Return the workspace and configuration setup values}
\usage{
getConfig(...)
}
\arguments{
\item{...}{any further arguments}
}
\value{
a list consisting of
\item{workspacePath}{a folder specifying the workspace path. This has to be
writable by the opencpu process. On a cloud opencpu server on Ubuntu, for example,
this requires a one-time modification of apparmor profiles to enable write
permissions to this path}
\item{defnPath}{the path where definition files will reside, organized by
computation identifiers}
\item{instancePath}{the path where instance objects will reside}
\item{defnFileName}{the name for the compdef definition files}
\item{dataFileName}{the name for the data files}
\item{instanceFileName}{the name for the instance files}
\item{ssl_verifyhost}{integer value, usually \code{1L}, but for testing with
snake-oil certs, one might set this to \code{0L}}
\item{ssl_verifypeer}{integer value, usually \code{1L}, but for testing with
snake-oil certs, one might set this to \code{0L}}
}
\description{
The function \code{getConfig} returns the values of the
configuration parameters set up by \code{distcompSetup}
}
\examples{
\dontrun{
getConfig()
}
}
\seealso{
\code{\link[=distcompSetup]{distcompSetup()}}
}
