% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical.R
\name{random.Categorical}
\alias{random.Categorical}
\title{Draw a random sample from a Categorical distribution}
\usage{
\method{random}{Categorical}(d, n = 1L, ...)
}
\arguments{
\item{d}{A \code{Categorical} object created by a call to \code{\link[=Categorical]{Categorical()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector containing values from \code{outcomes} of length \code{n}.
}
\description{
Draw a random sample from a Categorical distribution
}
\examples{

set.seed(27)

X <- Categorical(1:3, p = c(0.4, 0.1, 0.5))
X

Y <- Categorical(LETTERS[1:4])
Y

random(X, 10)
random(Y, 10)

pdf(X, 1)
log_pdf(X, 1)

cdf(X, 1)
quantile(X, 0.5)
\dontrun{
# cdfs are only defined for numeric sample spaces. this errors!
cdf(Y, "a")

# same for quantiles. this also errors!
quantile(Y, 0.7)
}

}
