% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logistic.R
\name{random.Logistic}
\alias{random.Logistic}
\title{Draw a random sample from a Logistic distribution}
\usage{
\method{random}{Logistic}(d, n = 1L, ...)
}
\arguments{
\item{d}{A \code{Logistic} object created by a call to \code{\link[=Logistic]{Logistic()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector of length \code{n}.
}
\description{
Draw a random sample from a Logistic distribution
}
\examples{

set.seed(27)

X <- Logistic(2, 4)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other Logistic distribution: \code{\link{cdf.Logistic}},
  \code{\link{pdf.Logistic}},
  \code{\link{quantile.Logistic}}
}
\concept{Logistic distribution}
