% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneralisedExtremeValue.R
\name{GEV}
\alias{GEV}
\title{Create a Generalised Extreme Value (GEV) distribution}
\usage{
GEV(mu = 0, sigma = 1, xi = 0)
}
\arguments{
\item{mu}{The location parameter, written \eqn{\mu} in textbooks.
\code{mu} can be any real number.  Defaults to \code{0}.}

\item{sigma}{The scale parameter, written \eqn{\sigma} in textbooks.
\code{sigma} can be any positive number.  Defaults to \code{1}.}

\item{xi}{The shape parameter, written \eqn{\xi} in textbooks.
\code{xi} can be any real number.  Defaults to \code{0}, which corresponds to a
Gumbel distribution.}
}
\value{
A \code{GEV} object.
}
\description{
The GEV distribution arises from the Extremal Types Theorem, which is rather
like the Central Limit Theorem (see \verb{\link{Normal}}) but it relates to
the \emph{maximum} of \eqn{n} i.i.d. random variables rather than to the sum.
If, after a suitable linear rescaling, the distribution of this maximum
tends to a non-degenerate limit as \eqn{n} tends to infinity then this limit
must be a GEV distribution. The requirement that the variables are independent
can be relaxed substantially. Therefore, the GEV distribution is often used
to model the maximum of a large number of random variables.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail and much greater clarity.

In the following, let \eqn{X} be a GEV random variable with location
parameter  \code{mu} = \eqn{\mu}, scale parameter \code{sigma} = \eqn{\sigma} and
shape parameter \code{xi} = \eqn{\xi}.

\strong{Support}:
\eqn{(-\infty, \mu - \sigma / \xi)} for \eqn{\xi < 0};
\eqn{(\mu - \sigma / \xi, \infty)} for \eqn{\xi > 0};
and \eqn{R}, the set of all real numbers, for \eqn{\xi = 0}.

\strong{Mean}: \eqn{\mu + \sigma[\Gamma(1 - \xi) - 1]/\xi} for
\eqn{\xi < 1, \xi \neq 0}{\xi < 1, \xi != 0};
\eqn{\mu + \sigma\gamma} for \eqn{\xi = 0}, where \eqn{\gamma}
is Euler's constant, approximately equal to 0.57722; undefined otherwise.

\strong{Median}: \eqn{\mu + \sigma[(\ln 2) ^ {-\xi} - 1]/\xi}{%
  \mu + \sigma[(ln 2)^(-\xi) - 1] / \xi} for \eqn{\xi \neq 0}{\xi != 0};
\eqn{\mu - \sigma\ln(\ln 2)}{\mu - \sigma ln(ln 2)} for \eqn{\xi = 0}.

\strong{Variance}:
\eqn{\sigma^2 [\Gamma(1 - 2 \xi) - \Gamma(1 - \xi)^2] / \xi^2}
for \eqn{\xi < 1 / 2, \xi \neq 0}{\xi < 1 / 2, \xi != 0};
\eqn{\sigma^2 \pi^2 / 6} for \eqn{\xi = 0}; undefined otherwise.

\strong{Probability density function (p.d.f)}:

If \eqn{\xi \neq 0}{\xi is not equal to 0} then
\deqn{f(x) = \sigma ^ {-1} [1 + \xi (x - \mu) / \sigma] ^ {-(1 + 1/\xi)}%
         \exp\{-[1 + \xi (x - \mu) / \sigma] ^ {-1/\xi} \}}{%
       f(x) = (1 / \sigma) [1 + \xi (x - \mu) / \sigma] ^ {-(1 + 1/\xi)}%
         exp{ -[1 + \xi (x - \mu) / \sigma] ^ (-1/\xi)}}
for \eqn{1 + \xi (x - \mu) / \sigma > 0}.  The p.d.f. is 0 outside the
support.

In the \eqn{\xi = 0} (Gumbel) special case
\deqn{f(x) = \sigma ^ {-1} \exp[-(x - \mu) / \sigma]%
        \exp\{-\exp[-(x - \mu) / \sigma] \}}{%
       f(x) = (1 / \sigma) exp[-(x - \mu) / \sigma]%
        exp{-exp[-(x - \mu) / \sigma]}}
for \eqn{x} in \eqn{R}, the set of all real numbers.

\strong{Cumulative distribution function (c.d.f)}:

If \eqn{\xi \neq 0}{\xi is not equal to 0} then
\deqn{F(x) = \exp\{-[1 + \xi (x - \mu) / \sigma] ^ {-1/\xi} \}}{%
       F(x) = exp{ -[1 + \xi (x - \mu) / \sigma] ^ (-1/\xi)} }
for \eqn{1 + \xi (x - \mu) / \sigma > 0}.  The c.d.f. is 0 below the
support and 1 above the support.

In the \eqn{\xi = 0} (Gumbel) special case
\deqn{F(x) = \exp\{-\exp[-(x - \mu) / \sigma] \}}{%
        F(x) = exp{ - exp[-(x - \mu) / \sigma]} }
for \eqn{x} in \eqn{R}, the set of all real numbers.
}
\examples{

set.seed(27)

X <- GEV(1, 2, 0.1)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
\seealso{
Other continuous distributions: 
\code{\link{Beta}()},
\code{\link{Cauchy}()},
\code{\link{ChiSquare}()},
\code{\link{Erlang}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{Frechet}()},
\code{\link{GP}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Logistic}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Tukey}()},
\code{\link{Uniform}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
