% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversityDynamics.r
\name{omit}
\alias{omit}
\title{Omission of taxa that have a poor occurrence record}
\usage{
omit(dat, tax = "genus", bin = "bin", coll = "collection_no",
  ref = "reference_no", om = "ref", filterNA = FALSE)
}
\arguments{
\item{dat}{\code{(data.frame)} Occurrence dataset, with \code{bin}, \code{tax} and \code{coll} as column names.}

\item{tax}{\code{(character)} The name of the taxon variable.}

\item{bin}{\code{(character)} The name of the bin variable (has to be \code{numeric} for the function to run). For time series, this is the time slice variable.}

\item{coll}{\code{(character)} The variable name of the collection identifiers.}

\item{ref}{\code{(character)} The variable name of the reference identifiers (optional).}

\item{om}{\code{(character)} The type of omission. \code{"coll"} omits occurrences of taxa that occurr only in one collection. \code{"ref"} omits occurrences of taxa that were described only in one reference. \code{"binref"} will omit the set of single reference taxa that were described by more than one references, but appear in only one reference in a time bin.}

\item{filterNA}{\code{(logical)} Additional entries can be added to influence the dataset that might not have reference or collection information (\code{NA} entries). These occurrences are treated as single-collection or single-reference taxa if the \code{na.rm} argument is set to \code{FALSE} (default). Setting this argument to \code{TRUE} will keep these entries. (see example)}
}
\description{
Function to quickly omit single-collection and single-reference taxa.
}
\details{
The function returns a \code{logical} vector, with a value for each row. \code{TRUE} values indicate rows to be omitted, \code{FALSE} values indicate rows to be kept. The function is embedded in the \code{\link{divDyn}} function, but can be called independently.
}
\examples{
# omit single-reference taxa
  data(corals)
  data(stages)
  toOmit <- omit(corals, bin="stg", tax="genus", om="ref")
  dat <- corals[!toOmit,]

# within divDyn
  # plotting
  tsplot(stages, shading="series", boxes="per", xlim=c(260,0), 
    ylab="range-through diversity (genera)", ylim=c(0,230))
  # multiple ref/slice required
  ddNoSing <- divDyn(corals, tax="genus", bin="stg", om="binref")
  lines(stages$mid, ddNoSing$divRT, lwd=2, col="red")

  # with the recent included (NA reference value)
  ddNoSingRec <- divDyn(corals, tax="genus", bin="stg",
    om="binref", filterNA=TRUE)
  lines(stages$mid, ddNoSingRec$divRT, lwd=2, col="blue")
  
  # legend
  legend("topleft", legend=c("no single-ref. taxa", 
    "no single-ref. taxa,\\n with recent"), 
    col=c("red", "blue"), lwd=c(2,2))
}
