% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{corals}
\alias{corals}
\title{Fossil occurrences of scleractinian (stony) corals from the Paleobiology Database}
\format{A \code{data.frame} with 29775 observations and 38 variables:
\describe{
	\item{\code{genus}}{Genus names of the occurrences. Cross referenced with a compiled table, the simplified version of this can be found in the supplementary material of Kiessling and Kocsis (2015).}
	\item{\code{collection_no}}{The number of the collection of the occurrence in the PaleoDB.}
	\item{\code{family}}{Family name of the occurrence.}
	\item{\code{abund_value}}{Abundance value.}
	\item{\code{abund_unit}}{Unit of abundance values.}
	\item{\code{reference_no}}{The reference number of the occurrence in the PaleoDB.}
	\item{\code{life_habit}}{The lifestyle of the occurring taxon.}
	\item{\code{diet}}{The diet of the occurring taxon.}
	\item{\code{country}}{Country of occurrence.}
	\item{\code{geoplate}}{Plate id of the occurrence.}
	\item{\code{lat}}{Present day latitude of the occurrence.}
	\item{\code{lng}}{Present day longitude of the occurrence.}
	\item{\code{paleolat}}{Reconstructed paleolatitude of the occurrence.}
	\item{\code{paleolng}}{Reconstructed paleolongitude of the occurrence.}
	\item{\code{period}}{Period of origin.}
	\item{\code{epoch}}{Epoch of origin.}
	\item{\code{subepoch}}{Subepoch of origin.}
	\item{\code{stage}}{Geologic stage of the embedding rocks.}
	\item{\code{early_interval}}{Early interval name registered in the PaleoDB dynamic time scale.}
	\item{\code{late_interval}}{Late interval name registered in the PaleoDB dynamic time scale.}
	\item{\code{max_ma}}{Maximum estimated age based on the PaleoDB dynamic time scale.}
	\item{\code{min_ma}}{Minimum estimated age based on the PaleoDB dynamic time scale.}
	\item{\code{stg}}{Bin number in the stage-level timescale \code{\link{stages}}.}
	\item{\code{Bin}}{Bin number in the PaleoDB 10 million year resolution timescale \code{\link{bins}}.}
	\item{\code{env}}{Environment of the occurrence: reefal \code{(r)}, non-reefal \code{(nr)} or unknown (\code{uk}), based on \code{\link{keys}}.}
	\item{\code{lith}}{Substrate of the occurrence: carbonate \code{(c)}, siliciclastic \code{(s)} or unknown (\code{uk}), based on \code{\link{keys}}.}
	\item{\code{latgroup}}{Latitude of the occurrence: tropical \code{(t)} or non-tropical \code{(nt)}.}
	\item{\code{bath}}{Inferred depth of the occurrence: deep \code{(deep)}, shallow \code{(shal)} or unknown (\code{uk}), based on \code{\link{keys}}.}
	\item{\code{gensp}}{The binomen of the occurrence.}
	\item{\code{ecology}}{Symbiotic status of the occurring coral: zooxanthellate \code{(z)} or azooxanthellate \code{(az}, including apozooxanthellates).}
	\item{\code{ecologyMostZ}}{Symbiotic status of the occurring coral, incorporating the uncertainty of inferred symbiotic status. This variable includes assignment with the maximum likely number of zooxanthellate genera.}
	\item{\code{ecologyMostAZ}}{Symbiotic status of the occurring coral, incorporating the uncertainty of inferred symbiotic status. This variable includes assignment with the maximum likely number of azooxanthellate genera.}
	\item{\code{growth}}{Growth type of the coral: \code{colonial} or \code{solitary}.}
	\item{\code{integration}}{Integration of corallites from the scale of 0 to 4. \code{solitary} corals are marked with 0s.}
}}
\source{
\url{http://www.paleobiodb.org/}
}
\usage{
corals
}
\description{
Example dataset to illustrate the package's basic functionalities.
}
\details{
This particular dataset was used in a study by Kiessling and Kocsis (2015). All occurrences of Scleractinia were downloaded from the Paleobiology Database (PaleoDB, \url{http://www.paleobiodb.org/}) on 23 September 2014, originally comprising 32420 occurrences. They were than cross-checked with data from Corallosphere (\url{http://corallosphere.org}). See the article text for details.

References

Kiessling, W., & Aberhan, M. (2007). Environmental determinants of marine benthic biodiversity dynamics through Triassic–Jurassic time. Paleobiology, 33(3), 414-434.
}
\keyword{datasets}
