% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice}
\alias{slice}
\title{Discretization of continuous time dimension - slicing}
\usage{
slice(x, breaks, offset = 0, ts = TRUE, revtime = TRUE)
}
\arguments{
\item{x}{(\code{numeric}) Vector of continouos age/time estimates.}

\item{breaks}{(\code{numeric}) Vector of boundaries, the breaks argument of the \code{\link[base]{cut}} function}

\item{offset}{(\code{numeric}) Single  value. If desired the resulting integer bin numbers can be offset by some amount.}

\item{ts}{(\code{logical}) Should a time scale object be also produced when the function is run?}

\item{revtime}{(\code{logical}) Should the time dimension be reversed? This argument is set to \code{TRUE} by default, meaning that the function will reverse the order of time: smaller values of \code{x} will be translated to higher values (\code{slc}) in the function output.}
}
\description{
The function will slices time with a given set of boundaries and produce a time scale object if desired.
}
\details{
Due to stratigraphic constraints, we can only process deep time data, when it is sliced to discrete bins. It is suggested that you do this separately for most of your analyses. This function is also used by the code{\link{divDyn}} function when \code{age} entries are provided.
}
\examples{
y<- runif(200, 0,100)
au <- slice(y, breaks=seq(0, 100, 10))
withTs <- slice(y, breaks=seq(0, 100, 10), ts=TRUE)
}
