% $Id: dives.Rd 260 2010-02-03 18:13:12Z sluque $
\name{dives}
\docType{data}

\alias{dives}
\alias{divesTDR}
\alias{divesTDRcalibrate}
\alias{divesSummary}

% -------------------------------------------------------------------------

\title{Sample of TDR data from a fur seal}



\description{This data set is meant to show a typical organization of a
  \acronym{TDR} *.csv file, suitable as input for \code{\link{readTDR}},
  or to construct a \code{\link{TDR}} object.  \code{divesTDR} and
  \code{divesTDRcalibrate} are example \code{\link{TDR}} and
  \code{\link{TDRcalibrate}} objects.}


\format{

  A comma separated value (csv) file with 69560 \acronym{TDR} readings
  with the following columns:

  \describe{
    \item{date}{Date}

    \item{time}{Time}

    \item{depth}{Depth in m}

    \item{light}{Light level}

    \item{temperature}{Temperature in degrees Celsius}

    \item{speed}{Speed in m/s}
  }

  The data are also provided as a \code{\link{TDR}} object (*.RData
  format) for convenience.

}


\details{

  The data are a subset of an entire \acronym{TDR} record, so they are
  not meant to make valid inferences from this particular
  individual/deployment.

  \code{divesTDR} is a \code{\link{TDR}} object representation of the
  data in \code{dives}.

  \code{divesTDRcalibrate} is a \code{\link{TDRcalibrate}} object
  representing the data in dives, calibrated at default criteria (see
  \code{\link{calibrateDepth}}), and 3 m offset.

  \code{divesSummary} is a data frame containing a summary of all dives
  in this dataset (see \code{\link{diveStats}} and
  \code{\link{stampDive}} for the information contained in this object.

}


\seealso{\code{\link{readTDR}}, \code{\link{diveStats}}.}


\source{Sebastian P. Luque, Christophe Guinet, John P.Y. Arnould}

% -------------------------------------------------------------------------

\examples{
dives <- read.csv(system.file(file.path("data", "dives.csv"),
                              package="diveMove"),
                  sep=";", na.strings="")
str(dives)

}


\keyword{datasets}
