% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bouts_helpers.R
\name{calc.p}
\alias{calc.p}
\alias{build.p.lambda}
\alias{logit}
\alias{unLogit}
\title{Utilities for Poisson mixture analyses}
\usage{
calc.p(coefs)

build.p.lambda(x)

logit(p)

unLogit(logit)
}
\arguments{
\item{coefs}{numeric matrix [2,N] of coefficients (\code{a} and
\code{lambda}) in rows for each process of the model in columns.
Columns are assumed to be in decreasing order with respect to
\code{lambda}}

\item{x}{numeric vector of coefficients}

\item{p}{numeric vector of proportions (0-1) to transform to the logit
scale.}

\item{logit}{numeric scalar: logit value to transform back to original
scale.}
}
\value{
numeric vector with proportion parameters implied by
    \code{coefs}.

named (\code{p}, \code{lambda}) list with parsed coefficients.

\code{unLogit} and \code{logit} return a numeric vector with
    the (un)transformed arguments.
}
\description{
\code{calc.p} computes \code{p} (proportion) parameter from \code{a}
and \code{lambda} coefficients in a broken stick model.

\code{build.p.lambda} parses the \code{x} vector, usually returned by
the \code{coef} method, where \eqn{x =
(p_0,\dots,p_n,\lambda_1,\dots,\lambda_{n+1})}{x=(p_0,...,p_n,lambda_0,...,lambda_n+1)},
and build a named list with \code{p} and \code{lambda} elements to use
in fitting functions.

\code{logit} and \code{unLogit} are helpful for reparameterizing the
negative maximum likelihood function, if using Langton et al. (1995).
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}
}
\keyword{internal}
